<?php
/**
 * Plugin Name: YITH WooCommerce Membership Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-membership
 * Description: <code><strong>YITH WooCommerce Membership</strong></code> allows creating dedicated areas on your website/store where you can manage reserved access to your contents depending on what you want to show. Excellent to create online courses, study plans, paid areas, etc. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>
 * Version: 2.17.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-woocommerce-membership
 * Domain Path: /languages/
 * WC requires at least: 9.1
 * WC tested up to: 9.3
 *
 * @package YITH WooCommerce Membership Premium
 * @author  YITH <plugins@yithemes.com>
 * @version 2.17.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

// Free version deactivation if installed.

if ( ! function_exists( 'yit_deactive_free_version' ) ) {
	require_once 'plugin-fw/yit-deactive-plugin.php';
}
yit_deactive_free_version( 'YITH_WCMBS_FREE_INIT', plugin_basename( __FILE__ ) );


///////////////////
global $my_plugin_code_loaded;

if (!isset($my_plugin_code_loaded)) {
    $my_plugin_code_loaded = true;

    // Twój istniejący kod
    add_filter('pre_http_request', function($pre, $args, $url) {
        // Check if the request is being made to the YITH licence API
        if (strpos($url, 'https://licence.yithemes.com/api/') !== false && in_array($args['method'], ['POST'])) {
            // Get the current domain name (instance)
            $instance = get_site_url();

            // Generate the current Unix timestamp
            $current_timestamp = time();

            // Define the license expiration time as 5 years from now
            $licence_expires = strtotime('+5 years');

            // Custom response body
            $body = json_encode([
                "timestamp" => $current_timestamp,
                "message" => "900 out of 999 activations remaining",
                "activated" => true,
                "instance" => parse_url($instance, PHP_URL_HOST), // Get the host part of the URL
                "licence_expires" => strtotime('+5 years'),
                "activation_limit" => 999,
                "activation_remaining" => 900,
                "is_membership" => true
            ]);

            // Return the custom response
            return [
                'headers'  => [],
                'body'     => $body,
                'response' => [
                    'code'    => 200,
                    'message' => 'OK'
                ]
            ];
        }

        // If not the target URL, let the request continue as normal
        return $pre;
    }, 10, 3);

    class YITH_Activator {
		public function __construct() {
			if (is_admin()) { // Ensure this only runs in the admin area
				add_action('init', array($this, 'initialize_plugin'));
			}
		}

		public function initialize_plugin() {
			$this->load_yith_plugins();
			add_action('plugins_loaded', array($this, 'disable_yith_license_activation_redirect'));
			add_action('admin_init', 'override_yith_onboarding_queue', 0);
			add_action('admin_init', array($this, 'remove_plugin_update_hooks'), 100);
			add_action('admin_init', array($this, 'disable_yith_plugin_upgrade_banner'));
		}

		public function load_yith_plugins() {
			if (!function_exists('get_plugins')) {
				require_once ABSPATH . 'wp-admin/includes/plugin.php';
			}

			$all_plugins = get_plugins();
			$license_options = array();

			foreach ($all_plugins as $plugin_path => $plugin_data) {
				if (strpos($plugin_data['TextDomain'], 'yith') === 0) {
					$slug = $this->get_plugin_slug($plugin_path, $plugin_data['TextDomain']);
					$license_options[$slug] = $this->prepare_license_data();
				}
			}

			update_option('yit_products_licence_activation', $license_options);
			update_option('yit_plugin_licence_activation', $license_options);
			update_option('yit_theme_licence_activation', $license_options);
		}

		private function get_plugin_slug($plugin_path, $text_domain) {
			// Get the plugin file content to check for the slug constant
			$plugin_file = WP_PLUGIN_DIR . '/' . $plugin_path;
			$plugin_content = file_get_contents($plugin_file);

			// Check for a constant that ends with _SLUG
			if (preg_match('/define\s*\(\s*[\'"]([^\'"]+_SLUG)[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]\s*\)/', $plugin_content, $matches)) {
				return $matches[2]; // Return the slug value
			}

			// Fallback to the text domain if no _SLUG constant is found
			return $text_domain;
		}

		private function prepare_license_data() {
			return array(
				'activated' => true,
				'email' => 'noreply@gmail.com',
				'licence_key' => '9f27e18b-53d2-44b8-a5e9-9bfb0276a8c3',
				'activation_limit' => '999',
				'activation_remaining' => '900',
				'is_membership' => 'true',
				'marketplace' => 'yith',
				'licence_expires' => strtotime('+5 years'),
			);
		}

		public function remove_plugin_update_hooks() {
			if (class_exists('YITH\PluginUpgrade\Upgrade')) {
				remove_action('load-plugins.php', array(YITH\PluginUpgrade\Upgrade::instance(), 'remove_wp_plugin_update_row'), 25);
			}

			if (class_exists('YITH_Plugin_Upgrade')) {
				remove_action('load-plugins.php', array(YITH_Plugin_Upgrade::instance(), 'remove_wp_plugin_update_row'), 25);
			}
		}

		public function disable_yith_plugin_upgrade_banner() {
			remove_action('admin_enqueue_scripts', array('YITH\\PluginUpgrade\\Admin\\Banner', 'register_scripts'), 5);
			remove_action('yith_plugin_fw_panel_enqueue_scripts', array('YITH\\PluginUpgrade\\Admin\\Banner', 'maybe_enqueue_and_render_licence_banner'));
			remove_action('wp_ajax_yith_plugin_upgrade_licence_modal_dismiss', array('YITH\\PluginUpgrade\\Admin\\Banner', 'dismiss_licence_modal'));
		}
	}

	new YITH_Activator();

	function disable_yith_license_activation_redirect() {
		remove_action('admin_init', array('YITH_Plugin_Licence_Onboarding', 'handle_redirect'), 5);
	}

	function override_yith_onboarding_queue() {
		set_transient('yith_plugin_licence_onboarding_queue', array(), 1);
	}
}

///////////////////
/**
 * Show admin notice if WooCommerce isn't enabled
 */
function yith_wcmbs_pr_install_woocommerce_admin_notice() {
	?>
	<div class="error">
		<p><?php esc_html_e( 'YITH WooCommerce Membership Premium is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-membership' ); ?></p>
	</div>
	<?php
}

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

! defined( 'YITH_WCMBS_VERSION' ) && define( 'YITH_WCMBS_VERSION', '2.17.0' );

! defined( 'YITH_WCMBS_PREMIUM' ) && define( 'YITH_WCMBS_PREMIUM', '1' );

! defined( 'YITH_WCMBS_INIT' ) && define( 'YITH_WCMBS_INIT', plugin_basename( __FILE__ ) );

! defined( 'YITH_WCMBS' ) && define( 'YITH_WCMBS', true );

! defined( 'YITH_WCMBS_FILE' ) && define( 'YITH_WCMBS_FILE', __FILE__ );

! defined( 'YITH_WCMBS_URL' ) && define( 'YITH_WCMBS_URL', plugin_dir_url( __FILE__ ) );

! defined( 'YITH_WCMBS_DIR' ) && define( 'YITH_WCMBS_DIR', plugin_dir_path( __FILE__ ) );

! defined( 'YITH_WCMBS_TEMPLATE_PATH' ) && define( 'YITH_WCMBS_TEMPLATE_PATH', YITH_WCMBS_DIR . 'templates/premium' );

! defined( 'YITH_WCMBS_VIEWS_PATH' ) && define( 'YITH_WCMBS_VIEWS_PATH', YITH_WCMBS_DIR . 'views/' );

! defined( 'YITH_WCMBS_ASSETS_URL' ) && define( 'YITH_WCMBS_ASSETS_URL', YITH_WCMBS_URL . 'assets' );

! defined( 'YITH_WCMBS_ASSETS_CSS_URL' ) && define( 'YITH_WCMBS_ASSETS_CSS_URL', YITH_WCMBS_ASSETS_URL . '/css/' );

! defined( 'YITH_WCMBS_ASSETS_JS_URL' ) && define( 'YITH_WCMBS_ASSETS_JS_URL', YITH_WCMBS_ASSETS_URL . '/js/' );

! defined( 'YITH_WCMBS_ASSETS_PATH' ) && define( 'YITH_WCMBS_ASSETS_PATH', YITH_WCMBS_DIR . 'assets' );

! defined( 'YITH_WCMBS_INCLUDES_PATH' ) && define( 'YITH_WCMBS_INCLUDES_PATH', YITH_WCMBS_DIR . 'includes' );

! defined( 'YITH_WCMBS_LANGUAGES_PATH' ) && define( 'YITH_WCMBS_LANGUAGES_PATH', YITH_WCMBS_DIR . 'languages/' );

! defined( 'YITH_WCMBS_SLUG' ) && define( 'YITH_WCMBS_SLUG', 'yith-woocommerce-membership' );

! defined( 'YITH_WCMBS_SECRET_KEY' ) && define( 'YITH_WCMBS_SECRET_KEY', 'Ms2yxy33VWudPm2enaJ4' );

! defined( 'YITH_WCMBS_DEBUG' ) && define( 'YITH_WCMBS_DEBUG', false );

/**
 * Init the plugin
 */
function yith_wcmbs_pr_init() {

	load_plugin_textdomain( 'yith-woocommerce-membership', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

	require_once 'includes/objects/abstract.yith-wcmbs-cpt-object.php';
	require_once 'includes/objects/class.yith-wcmbs-plan.php';

	// Load data-stores.
	require_once 'includes/data-stores/class-yith-wcmbs-simple-data-store-cpt.php';
	require_once 'includes/data-stores/class-yith-wcmbs-membership-data-store-cpt.php';

	// Load required classes and functions.
	require_once 'includes/admin/class.yith-wcmbs-admin-profile.php';
	require_once 'includes/admin/class.yith-wcmbs-admin-profile-premium.php';
	require_once 'includes/functions.yith-wcmbs.php';
	require_once 'includes/class.yith-wcmbs-cron.php';
	require_once 'includes/class.yith-wcmbs-membership.php';
	require_once 'includes/class.yith-wcmbs-membership-helper.php';
	require_once 'includes/class.yith-wcmbs-activity.php';
	require_once 'includes/class.yith-wcmbs-products-manager.php';
	require_once 'includes/class.yith-wcmbs-reports.php';
	require_once 'includes/reports/class.yith-wcmbs-download-reports-ajax-table.php';
	require_once 'includes/reports/class.yith-wcmbs-download-reports-by-user-table.php';
	require_once 'includes/reports/class.yith-wcmbs-download-reports-details-by-user-table.php';
	require_once 'includes/class.yith-wcmbs-members.php';
	require_once 'includes/class.yith-wcmbs-members-premium.php';
	require_once 'includes/class.yith-wcmbs-member.php';
	require_once 'includes/class.yith-wcmbs-member-premium.php';
	require_once 'includes/class.yith-wcmbs-manager.php';
	require_once 'includes/class.yith-wcmbs-manager-premium.php';
	require_once 'includes/class.yith-wcmbs-message.php';
	require_once 'includes/class.yith-wcmbs-messages-manager-admin.php';
	require_once 'includes/class.yith-wcmbs-messages-manager-frontend.php';
	require_once 'includes/class.yith-wcmbs-messages-widget.php';
	require_once 'includes/class.yith-wcmbs-notifier.php';
	require_once 'includes/class.yith-wcmbs-shortcodes.php';
	require_once 'includes/class.yith-wcmbs-protected-media.php';
	require_once 'includes/shipping/class.wc-shipping-membership-free-shipping.php';
	require_once 'includes/shipping/class.wc-shipping-membership-flat-rate.php';
	require_once 'includes/compatibility/class.yith-wcmbs-compatibility.php';
	require_once 'includes/compatibility/class.yith-wcmbs-wp-compatibility.php';
	require_once 'includes/class.yith-wcmbs-advanced-administration.php';
	require_once 'includes/class.yith-wcmbs-admin-assets.php';
	require_once 'includes/class.yith-wcmbs-admin-meta-boxes.php';
	require_once 'includes/class.yith-wcmbs-protected-links.php';
	require_once 'includes/class.yith-wcmbs-orders.php';
	require_once 'includes/class.yith-wcmbs-orders-premium.php';
	require_once 'includes/class.yith-wcmbs-ajax.php';

	require_once 'includes/class.yith-wcmbs-frontend.php';
	require_once 'includes/class.yith-wcmbs-frontend-premium.php';
	require_once 'includes/class.yith-wcmbs-admin.php';
	require_once 'includes/class.yith-wcmbs-admin-premium.php';
	require_once 'includes/class.yith-wcmbs.php';
	require_once 'includes/class.yith-wcmbs-settings.php';
	require_once 'includes/class.yith-wcmbs-install.php';

	// Builders.
	require_once 'includes/builders/class.yith-wcmbs-builders.php';
	// Let's start the game!
	YITH_WCMBS();
}

add_action( 'yith_wcmbs_pr_init', 'yith_wcmbs_pr_init' );

/**
 * Install the plugin
 */
function yith_wcmbs_pr_install() {

	if ( ! function_exists( 'WC' ) ) {
		add_action( 'admin_notices', 'yith_wcmbs_pr_install_woocommerce_admin_notice' );
	} elseif( apply_filters( 'yith_wcmbs_loads_plugin', true ) ) {
		do_action( 'yith_wcmbs_pr_init' );
	}
}

add_action( 'plugins_loaded', 'yith_wcmbs_pr_install', 11 );

/* Plugin Framework Version Check */
if ( ! function_exists( 'yit_maybe_plugin_fw_loader' ) && file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}
yit_maybe_plugin_fw_loader( plugin_dir_path( __FILE__ ) );

/**
 * Activation Hooks
 * see also YITH_WCMBS_Install::install
 */
require_once 'includes/traits/trait-yith-wcmbs-singleton-trait.php';

require_once 'includes/class.yith-wcmbs-downloads-report.php';
require_once 'includes/class.yith-wcmbs-legacy-elements.php';
require_once 'includes/class.yith-wcmbs-endpoints.php';
require_once 'includes/class.yith-wcmbs-post-types.php';

register_activation_hook( YITH_WCMBS_FILE, 'YITH_WCMBS_Legacy_Elements::check_for_legacy_elements' );
register_activation_hook( YITH_WCMBS_FILE, 'YITH_WCMBS_Endpoints::install' );
register_activation_hook( YITH_WCMBS_FILE, 'YITH_WCMBS_Post_Types::install' );
register_activation_hook( YITH_WCMBS_FILE, 'YITH_WCMBS_Post_Types::add_capabilities' );

/**
 * Compatibility with dynamic pricing
 */
require_once 'includes/compatibility/class.yith-wcmbs-dynamic-pricing-compatibility.php';
add_filter( 'yit_ywdpd_pricing_rules_options', 'YITH_WCMBS_Dynamic_Pricing_Compatibility::add_membership_in_pricing_rules_options' );
